﻿<%@ import Namespace="System.Globalization" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Umowa o pracę</title>
		<script runat="server">

	public enum StawkaNettoBrutto {
        brutto, netto
    }

    static string reprez = "";
		    
	public class _SrInfo: SerializableContextBase {

        public _SrInfo(Context context): base(context) {
        }
		
		string reprezentant = "";
        [Priority(10)]
		[Caption("Reprezent. pracodawcę")]
		public string Reprezentant {
            get { return reprezentant; }
			set {
                reprezentant = value;
                reprez = reprezentant;
				OnChanged(EventArgs.Empty);
			}
		}

        bool pelneStanowisko = false;
        [Priority(20)]
        [Caption("Stanowisko pełna nazwa")]
        public bool PelneStanowisko {
            get { return pelneStanowisko; }
            set {
                pelneStanowisko = value;
                OnChanged(EventArgs.Empty);
            }
        }
    
        bool pelnaFunkcja = false;
        [Priority(30)]
        [Caption("Funkcja pełna nazwa")]
        public bool PelnaFunkcja {
            get { return pelnaFunkcja; }
            set {
                pelnaFunkcja = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    public class _Info : ContextBase {

        public _Info(Context context) : base(context) {
            stanNaDzien = ((ActualDate)context[typeof(ActualDate)]).Actual;
            if (reprezentant == "")
                reprezentant = KadryModule.GetInstance(context).Config.Wydruki.OsobaReprezentującaPracodawcę;
        }

        string reprezentant = reprez;
        [Priority(10)]
        [Caption("Reprezent. pracodawcę")]
        public string Reprezentant {
            get { return reprezentant; }
            set {
                reprezentant = value;
                OnChanged(EventArgs.Empty);
            }
        }

        StawkaNettoBrutto stawka;
        [Priority(20)]
        [Caption("Stawka")]
        public StawkaNettoBrutto Stawka {
            get { return stawka; }
            set {
                stawka = value;
                OnChanged(EventArgs.Empty);
            }
        }

        int iloscKopii = 1;
        [Priority(30)]
        [Caption("Ilość kopii")]
        public int IloscKopii {
            get { return iloscKopii; }
            set {
                if (value <= 0)
                    value = 1;
                iloscKopii = value;
                OnChanged(EventArgs.Empty);
            }
        }

        Date stanNaDzien;
        [Priority(40)]
        [Caption("Dodatki na dzień")]
        public Date StanNaDzien {
            get { return stanNaDzien; }
            set {
                stanNaDzien = value;
                OnChanged(EventArgs.Empty);
            }
        }
        
        bool wypowiedzenie = false;
        [Priority(50)]
        [Caption("Wypowiedz.Art.33 KP")]
        public bool Wypowiedzenie {
            get { return wypowiedzenie; }
            set {
                wypowiedzenie = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    _Info info;
    [Context]
    public _Info Info {
        set { info = value; }
    }

    _SrInfo srinfo;
    [SettingsContext]
    public _SrInfo SrInfo {
        set { srinfo = value; }
    }

    void dc_ContextLoad(Object sender, EventArgs e) {
        PracHistoria ph = (PracHistoria)dc[typeof(PracHistoria)];
        ReportHeader1["TYP"] = CaptionAttribute.EnumToString(ph.Etat.TypUmowy).ToUpper();
		
		dlReprezentant.EditValue = info.Reprezentant;
        labelNettoBrutto.EditValue = info.Stawka;
        labelStanowisko.EditValue = GetStanowisko(ph);
        labelFunkcja.EditValue = GetFunkcja(ph);
		
        FromTo okres = ph.Etat.Okres;
        if (okres.To==Date.MaxValue)
            dlNaOkres.EditValue = string.Format("od <strong>{0}</strong>", okres.From);
        else
            dlNaOkres.EditValue = string.Format("od <strong>{0}</strong> do <strong>{1}</strong>", okres.From, okres.To);
    
        if (ph.Etat.MiejscePracy!="")
            dlMiejsce.EditValue = ph.Etat.MiejscePracy;
        else
            dlMiejsce.EditValue = CoreModule.GetInstance(dc).Config.Firma.AdresSiedziby.ToString();
            
		string osoba = ph.Plec==PłećOsoby.Kobieta ? "otrzymałam" : "otrzymałem";
		stInfo.Caption = "Oświadczam, że egzemplarz niniejszej umowy "+osoba+" i po zapoznaniu się z jej treścią zaproponowane mi warunki pracy i wynagrodzenia przyjmuję bez zastrzeżeń. Równocześnie przyjmuję do wiadomości treść obowiązującego u Pracodawcy regulaminu pracy i oświadczam, że zobowiązuję się do przestrzegania jego postanowień pod rygorem odpowiedzialności dyscyplinarnej.";
		
		labelRodzajStawki.EditValue = CaptionAttribute.EnumToString(ph.Etat.Zaszeregowanie.RodzajStawki).ToLower();
        if (ph.Etat.Wymiar == Fraction.One)
            DataLabel20.EditValue = "......";
        else
            DataLabel20.EditValue = "<strong>" + ph.Etat.LimitNadgodzin + "</strong>";
		
		string ss = "";
		foreach (Dodatek d in ph.Pracownik.Dodatki) {
			DodHistoria dh = d[info.StanNaDzien];
            if (dh.Okres.Contains(info.StanNaDzien) && dh.Element.Dodatkowe.DodatekDoEtatu) 
				ss += string.Format("&nbsp;&nbsp;&nbsp;{0}{1}<br>", dh.Element.Nazwa, WarunkuDodatku(dh));
		}
		labelDodatki.EditValue = ss;			

        DataLabel14.EditValue = GetMiejscowosc();

        bool wypowiedzenie = info.Wypowiedzenie ?
            (ph.Etat.TypUmowy == TypUmowyOPrace.NaCzasOkreślony) && (ph.Etat.OkresZatrudnienia.Months > 6) : false;
        wypowiedzenie33.Visible = wypowiedzenie;
        DataLabel2.EditValue = wypowiedzenie ? "6" : "5";
       
        ArrayList al = new ArrayList();
        for (int i = 0; i < info.IloscKopii; i++)
            al.Add(ph);
        DataRepeater1.DataSource = al;
    }

    string GetStanowisko(PracHistoria ph) {
        string stanowiskoPelne = "";
        if (srinfo.PelneStanowisko)
            stanowiskoPelne = ph.Etat.StanowiskoPełne;
        if (stanowiskoPelne.Length == 0)
            stanowiskoPelne = ph.Etat.Stanowisko;
        return stanowiskoPelne;
    }

    string GetFunkcja(PracHistoria ph) {
        string funkcjaPelna = "";
        if (srinfo.PelnaFunkcja)
            funkcjaPelna = ph.Etat.FunkcjaPełna;
        if (funkcjaPelna.Length == 0)
            funkcjaPelna = ph.Etat.Funkcja;
        return funkcjaPelna;
    }

    string GetMiejscowosc() {
        string miejscowosc = ReportHeader.GetPieczątka(dc).Adres.Miejscowosc;
        if (miejscowosc.Length == 0)
            miejscowosc = CoreModule.GetInstance(dc).Config.Firma.AdresSiedziby.Miejscowosc;
        return miejscowosc;
    }
    
    void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
    }

	string WarunkuDodatku(DodHistoria dh) {
		string ss = "";
		
		if (dh.Procent!=Percent.Zero)
			ss = DodajParametr(ss, dh.Element.Algorytm.DodProcent, dh.Procent);
			
		if (dh.Ulamek!=Fraction.Zero)
			ss = DodajParametr(ss, dh.Element.Algorytm.DodUlamek, dh.Ulamek);
			
		if (dh.Wspolczynnik!=0m)
			ss = DodajParametr(ss, dh.Element.Algorytm.DodWspolczynnik, dh.Wspolczynnik);

		if (dh.Podstawa!=Currency.Zero)
			ss = DodajParametr(ss, dh.Element.Algorytm.DodPodstawa, dh.Podstawa.ToString("u", CultureInfo.CurrentCulture));
			
		if (dh.Czas!=Time.Zero)
			ss = DodajParametr(ss, dh.Element.Algorytm.DodCzas, dh.Czas);
			
		if (dh.Dni!=0)
			ss = DodajParametr(ss, dh.Element.Algorytm.DodDni, dh.Dni);
			
		if (ss=="")
			return "";
		return "&nbsp;(" + ss + ")";
    }
    
    string DodajParametr(string ss, string label, object value) {
		if (ss!="")
			ss += ",&nbsp;";
		ss += string.Format("<strong>{1}</strong>", label.ToLower(), value);
		return ss;
    }

	static void Msg(object value) {
    }
		        
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="UmowaOPracę" method="post" runat="server">
			<EA:DATACONTEXT id="dc" runat="server" OnContextLoad="dc_ContextLoad" TypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace"></EA:DATACONTEXT>
            <ea:DataRepeater ID="DataRepeater1" runat="server" OnBeforeRow="DataRepeater1_BeforeRow"
                RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace" Width="100%" Height="161px">
            <ea:SectionMarker ID="SectionMarker9" runat="server"></ea:SectionMarker>
		    <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" 
				ResetPageCounter="True"></ea:PageBreak>
			<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" 
                title="&lt;center&gt;UMOWA O PRACĘ %TYP%&lt;/center&gt;" 
                runat="server"></cc1:ReportHeader>
			<p></p>
            <font face="Tahoma" size="2">
			<p>REGON:&nbsp; 
            <ea:datalabel id="Datalabel4" runat="server" 
                DataMember="Session.Core.Config.Firma.Pieczątka.REGON">
            </ea:datalabel> 
            <BR> EKD:&nbsp;
            <ea:datalabel id="Datalabel17" runat="server" 
                DataMember="Session.Core.Config.Firma.Pieczątka.EKD" >
            </ea:datalabel>
            </p>
			<p>Zawarta w dniu&nbsp;
				<ea:datalabel id="DataLabel10" runat="server" DataMember="Etat.DataZawarcia" ></ea:datalabel>
				&nbsp;w&nbsp;
				<ea:datalabel id="DataLabel14" runat="server"></ea:datalabel>
				&nbsp;pomiędzy: 
			</p>
			<table id="Table1" cellSpacing="0" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma">
			<tbody>
				<tr>
					<td width="30px" valign="top" align="right">1.</td><td width="5px"></td>
					<td>
					    <ea:datalabel id="DataLabel15" runat="server" 
                            DataMember="Session.Core.Config.Firma.Pieczątka.Nazwa" ></ea:datalabel>
					    , z siedzibą w&nbsp;
					    <ea:datalabel id="DataLabel16" runat="server" 
                            DataMember="Session.Core.Config.Firma.AdresSiedziby"></ea:datalabel>
					    &nbsp;reprezentowanym przez
						    <ea:datalabel id="dlReprezentant" runat="server" CssClass="style1"></ea:datalabel>, a
                    </td>
                </tr>
				<tr>
					<td width="30px" valign="top" align="right">2.</td><td width="5px"></td>
					<td>
						<ea:datalabel id="DataLabel5" runat="server" DataMember="Plec" Bold="False">
							<ValuesMap>
								<ea:ValuesPair Key="Kobieta" Value="Panią"></ea:ValuesPair>
								<ea:ValuesPair Key="Mężczyzna" Value="Panem"></ea:ValuesPair>
							</ValuesMap>
						</ea:datalabel>
				        &nbsp;
				        <ea:datalabel id="DataLabel1" runat="server" 
                            DataMember="Pracownik.ImięNazwisko" ></ea:datalabel>
				        &nbsp;
					        <ea:datalabel id="DataLabel6" runat="server" DataMember="Plec" Bold="False">
						        <ValuesMap>
							        <ea:ValuesPair Key="Kobieta" Value="zamieszkałą"></ea:ValuesPair>
							        <ea:ValuesPair Key="Mężczyzna" Value="zamieszkałym"></ea:ValuesPair>
						        </ValuesMap>
					        </ea:datalabel>
					        &nbsp;w 
				        <ea:datalabel id="DataLabel3" runat="server" DataMember="Adres"></ea:datalabel>
				        .<BR>
					        Numer ewidencyjny PESEL&nbsp;
					        <ea:datalabel id="Datalabel18" runat="server" DataMember="PESEL"></ea:datalabel>.
                    </td>
                </tr>
				<tr>
					<td width="30px" valign="top" align="right">3.</td><td width="5px"></td>
					<td>Strony ustalają następujące warunki zatrudnienia:<br>
						<table id="Table2" cellSpacing="0" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma">
						<tbody>
							<tr>
								<td width="30px" valign="top" align="right">a.</td><td width="5px"></td>
								<td>rodzaj umówionej pracy:&nbsp;
					                <ea:datalabel id="DataLabel13" runat="server" DataMember="Etat.TypUmowy"></ea:datalabel>
					                <ea:datalabel id="dlNaOkres" runat="server" Bold="False"></ea:datalabel>
					                , na stanowisku 
					                <ea:datalabel id="labelStanowisko" runat="server"></ea:datalabel>
					                , funkcja&nbsp;
					                <ea:datalabel id="labelFunkcja" runat="server"></ea:datalabel>
					                <br>
                                </td>
                            </tr>
							<tr>
								<td width="30px" valign="top" align="right">b.</td><td width="5px"></td>
								<td>miejsce wykonywania pracy:&nbsp;
					                <ea:datalabel id="dlMiejsce" runat="server"></ea:datalabel>
					                &nbsp;<br>
                                </td>
                            </tr>
							<tr>
								<td width="30px" valign="top" align="right">c.</td><td width="5px"></td>
								<td>wymiar czasu pracy:&nbsp;
					                <ea:datalabel id="DataLabel7" runat="server" DataMember="Etat.Zaszeregowanie.Wymiar"></ea:datalabel>
					                <br>
                                </td>
                            </tr>
							<tr>
								<td width="30px" valign="top" align="right">d.</td><td width="5px"></td>
								<td>wynagrodzenie:&nbsp;
					                <ea:datalabel id="DataLabel8" runat="server" DataMember="Etat.Zaszeregowanie.Stawka"
						                Format="{0:u}"></ea:datalabel>&nbsp;
					                <ea:datalabel id="labelRodzajStawki" runat="server"></ea:datalabel>
					                <ea:datalabel id="labelNettoBrutto" runat="server"></ea:datalabel>
					                <br>
						            <ea:datalabel id="labelDodatki" runat="server" Bold="False"></ea:datalabel>
						            &nbsp;&nbsp; 
						            ............................................................................
						            <br>
						            &nbsp;&nbsp; 
						            ............................................................................&nbsp;&nbsp;
						            <br>
						            &nbsp;&nbsp; (inne składniki wynagrodzenia i ich wysokość oraz podstawa prawna)
						            <br>
                                </td>
                            </tr>
							<tr>
								<td width="30px" valign="top" align="right">e.</td><td width="5px"></td>
								<td>inne warunki zatrudnienia .....................................
						            <br>
						            &nbsp;&nbsp; 
						            ............................................................................
						            <br>
						            &nbsp;&nbsp; 
						            ............................................................................<BR>
                                </td>
                            </tr>
							<tr>
								<td width="30px" valign="top" align="right">f.</td><td width="5px"></td>
								<td>dopuszczalna liczba godzin pracy ponad określony w umowie wymiar czasu pracy*: 
					                <ea:datalabel id="DataLabel20" runat="server" Bold="False"></ea:datalabel>
                                </td>
                            </tr>
                        </tbody>
                        </table>
                    </td>
                </tr>
    		    <tr>
					<td width="30px" valign="top" align="right">4.</td><td width="5px"></td>
					<td>Dzień rozpoczęcia pracy&nbsp;
					    <ea:datalabel id="DataLabel9" runat="server" DataMember="Etat.DataRozpPracy"></ea:datalabel>.
                    </td>
                </tr>
                <ea:Section ID="wypowiedzenie33" runat="server">
				<tr>
					<td width="30px" valign="top" align="right">5.</td><td width="5px"></td>
					<td>Strony dopuszczają możliwość wcześniejszego rozwiązania umowy za dwutygodniowym okresem wypowiedzenia
                        gdy umowa opiewa na okres dłuższy niż 6 miesięcy zgodnie z art. 33 Kodeksu Pracy.
                    </td>
                </tr>
                </ea:Section>
				<tr>
					<td width="30px" valign="top" align="right">
					    <ea:datalabel id="DataLabel2" runat="server" Bold="false"></ea:datalabel>.
                    </td><td width="5px"></td>
					<td>Inne postanowienia szczegółowe 
						..............................<BR>
					    ...............................................................................<BR>
						...............................................................................<BR>
                    </td>
                </tr>
            </tbody>
            </table>
            <p>* Dotyczy umowy o pracę z pracownikiem zatrudnionym w niepełnym wymiarze czasu pracy<BR></p>
	        <ea:pagebreak id="PageBreak2" runat="server" Required="False"></ea:pagebreak>
			<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False">
				<Subtitles>
					<cc1:FooterSubtitle Caption="data i podpis pracownika" Width="50"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="podpis pracodawcy" Width="50"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="?" ID="stInfo" SubtitleType="CenterText" Width="100"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="data i podpis pracownika" Width="50"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="podpis przyjmującego oświadczenie" Width="50"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:ReportFooter>
        </font>
		<ea:SectionMarker ID="SectionMarker8" runat="server" SectionType="Footer"></ea:SectionMarker>
        </ea:DataRepeater>
		</form>
	</body>
</HTML>
